import java.net.*;
import java.io.*;

public class Client
{
  public static void main(String args[])
  {
    //pobranie i sprawdzenie otrzymanych argumentw
    if (args.length < 2){
      System.out.println("Wywoanie programu: Client host port");
      System.exit(-1);
    }
    String host = args[0];
    int port = 0;
    try{
      port = new Integer(args[1]).intValue();
    }
    catch(NumberFormatException e){
      System.out.println("Nieprawidowy argument: port");
      System.exit(-1);
    }
    //Inicjalizacja gniazda klienckiego
    Socket clientSocket = null;
    try{
      clientSocket = new Socket(host, port);
    }
    catch(UnknownHostException e){
      System.out.println("Nieznany host.");
      System.exit(-1);
    }
    catch(ConnectException e){
      System.out.println("Poczenie odrzucone.");
      System.exit(-1);
    }
    catch(IOException e){
      System.out.println("Bd wejcia-wyjcia: " + e);
      System.exit(-1);
    }
    System.out.println("Poczono z " + clientSocket);

    //Deklaracje zmiennych strumieniowych 
    String line = null;
    BufferedReader brSockInp = null;
    BufferedReader brLocalInp = null;
    DataOutputStream out = null;
    
    //Utworzenie strumieni
    try{
      out = new DataOutputStream(clientSocket.getOutputStream());
      brSockInp = new BufferedReader(
        new InputStreamReader(
          clientSocket.getInputStream()));
      brLocalInp = new BufferedReader(
        new InputStreamReader(System.in));
    }
    catch(IOException e){
      System.out.println("Bd przy tworzeniu strumieni: " + e);
      System.exit(-1);
    }
    //Ptla gwna klienta
    while(true){
      try{
        line = brLocalInp.readLine();
        if(line != null){
          System.out.println("Wysyam: " + line);
          out.writeBytes(line + '\n');
          out.flush();
        }
        if(line == null || "quit".equals(line)){
          System.out.println("Koczenie pracy...");
          clientSocket.close();
          System.exit(0);
        }
        brSockInp.readLine();
        System.out.println("Otrzymano: " + line);
      }
      catch(IOException e){
        System.out.println("Bd wejcia-wyjcia: " + e);
        System.exit(-1);
      }
    }
  }
}

